package ru.yandex.chemodan.app.stat.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimits;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimitsRegistry;
import ru.yandex.chemodan.app.stat.web.ConvertToDataSize;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Lev Tolmachev
 */
@ActionContainer
public class ChannelLimitsAdminPage {
    private static final Logger logger = LoggerFactory.getLogger(ChannelLimitsAdminPage.class);

    private final ChannelLimitsRegistry channelLimitsRegistry;
    private final LimitsManager limitsManager;

    public ChannelLimitsAdminPage(ChannelLimitsRegistry channelLimitsRegistry, LimitsManager limitsManager) {
        this.channelLimitsRegistry = channelLimitsRegistry;
        this.limitsManager = limitsManager;
    }

    @ZAction(file = "ChannelLimitsAdminPage.xsl", defaultAction = true)
    @Path("/channel-limits")
    public ChannelLimitsList channelLimitsList() {
        return new ChannelLimitsList(Cf.list(channelLimitsRegistry.getLimits().values()));
    }

    @ZAction(engineId = "text")
    @Path("/channel-limits/set")
    public EmptyContentPojo setChannelLimits(
            @RequestParam("channel")
            String channel,
            @RequestParam("auth")
            boolean auth,
            @RequestParam(value = "traffic", ignoreEmpty = true, customConverter = ConvertToDataSize.class)
            Option<DataSize> traffic,
            @RequestParam(value = "views", ignoreEmpty = true)
            Option<Long> views)
    {
        limitsManager.changeChannelLimits(channel, auth, traffic, views);
        throw new ZRedirectException("/channel-limits");
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    @XmlRootElement(name = "content")
    static final class ChannelLimitsList {
        public final ListF<ChannelLimits> limits;

        public ChannelLimitsList(ListF<ChannelLimits> values) {
            limits = values;
        }
    }
}
