<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
        >

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Channel limits</h2>
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#set-limits">
                Set limits
            </button>
            <br/><br/>
            <xsl:apply-templates select="limits">
                <xsl:sort select="channel-name"/>
            </xsl:apply-templates>

            <div class="modal fade" id="set-limits" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>
                            <h3>Set channel limits</h3>
                        </div>
                        <form class="form-horizontal" action="/z/channel-limits/set">
                            <div class="modal-body">
                                <div class="control-group">
                                    <label class="control-label" for="inputChannel">Channel</label>
                                    <div class="controls">
                                        <select name="channel" id="inputChannel">
                                            <option selected="selected" value="simple">simple</option>
                                            <option value="folder">folder</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputAuth">Auth/public</label>
                                    <div class="controls">
                                        <select name="auth" id="inputAuth">
                                            <option value="true">Auth</option>
                                            <option value="false">Public</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputTraffic">Traffic</label>
                                    <div class="controls">
                                        <input type="text" name="traffic" id="inputTraffic" placeholder="100G"/>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputViews">Views</label>
                                    <div class="controls">
                                        <input type="text" name="views" id="inputViews" placeholder="1000"/>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Save limits</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="limits">
        <h3>
            <xsl:value-of select="channel-name"/>
        </h3>
        <table class="table">
        <xsl:if test="count(auth-limit/traffic) > 0 or count(auth-limit/views) > 0">
            <tr>
                <td>
                    <h4>auth</h4>
                </td>
                <td>
                    <xsl:apply-templates select="auth-limit"/>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="public-limit/traffic or public-limit/views">
            <tr>
                <td>
                    <h4>public</h4>
                </td>
                <td>
                    <xsl:apply-templates select="public-limit"/>
                </td>
            </tr>
        </xsl:if>
        </table>
    </xsl:template>

    <xsl:template match="auth-limit|public-limit">
        <span title="traffic">
            traffic: <xsl:value-of select="z:format-data-size(traffic)"/>
        </span>
        <br/>
        views: <xsl:value-of select="views"/> <br/>
    </xsl:template>

</xsl:stylesheet>
