package ru.yandex.chemodan.app.stat.admin;

import javax.annotation.PostConstruct;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.block.BlockDownloadsManager;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimitsRegistry;
import ru.yandex.chemodan.app.stat.limits.mediatype.MediatypeLimitsRegistry;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.chemodan.app.stat.storage.PeriodSummaryStatsDao;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mulca.MulcaClientContextConfiguration;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.GroupOrHost;

/**
 * @author Lev Tolmachev
 */
@Configuration
@Import({
        MulcaClientContextConfiguration.class,
        ZkAdminContextConfiguration.class
})
public class DiskStatAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Autowired
    @Qualifier("channelLimitsRegistry")
    private ChannelLimitsRegistry channelLimitsRegistry;
    @Autowired
    @Qualifier("antiPornoLimitsRegistry")
    private ChannelLimitsRegistry antiPornoLimitsRegistry;
    @Autowired
    private LimitsManager limitsManager;
    @Autowired
    private WhitelistRegistry whitelistRegistry;
    @Autowired
    private MediatypeLimitsRegistry mediatypeLimitsRegistry;
    @Autowired
    private PeriodSummaryStatsDao periodSummaryStatsDao;
    @Autowired
    private BlockDownloadsManager blockDownloadsManager;

    @Autowired
    private Conductor conductor;

    @Autowired
    private DiskStatManager diskStatManager;
    @Value("${download-stat.aggregation.period}")
    private Duration period;

    @Value("${conductor.downloaders.group}")
    private GroupOrHost downloaders;

    @Autowired
    private MpfsClient mpfsClient;

    @Autowired
    @MulcaClientContextConfiguration.Mulca
    private HttpClient mulcaHttpClient;

    @Value("${mulca.service}")
    private String mulcaService;
    @Value("${mulca.namespace}")
    private String mulcaNamespace;

    @PostConstruct
    public void init() {
        ChannelLimitsAdminPage limitsAdminPage = new ChannelLimitsAdminPage(channelLimitsRegistry, limitsManager);
        AntiPornoLimitsAdminPage antiPornoLimitsAdminPage =
                new AntiPornoLimitsAdminPage(antiPornoLimitsRegistry, limitsManager);
        MediatypeLimitsAdminPage mediatypeLimitsAdminPage =
                new MediatypeLimitsAdminPage(mediatypeLimitsRegistry, limitsManager);
        WhitelistAdminPage whitelistAdminPage = new WhitelistAdminPage(whitelistRegistry);
        FileStatsAdminPage fileStatsAdminPage = new FileStatsAdminPage(period, diskStatManager, limitsManager,
                mpfsClient);
        LimitedFilesAdminPage limitedFilesAdminPage = new LimitedFilesAdminPage(period, limitsManager,
                blockDownloadsManager);
        PeriodSummaryAdminPage periodSummaryAdminPage = new PeriodSummaryAdminPage(period, periodSummaryStatsDao);

        adminApp.registerPlain("/mulca-proxy", new MulcaProxyServlet(conductor.hostsFromString(downloaders),
                mulcaHttpClient, mulcaService, mulcaNamespace));

        adminApp.registerAdminPage("Channel", Option.of("Limits"), limitsAdminPage);
        adminApp.registerAdminPage("Anti Porno", Option.of("Limits"), antiPornoLimitsAdminPage);
        adminApp.registerAdminPage("Mediatype", Option.of("Limits"), mediatypeLimitsAdminPage);
        adminApp.registerAdminPage("Whitelist", Option.of("Limits"), whitelistAdminPage);
        adminApp.registerAdminPage("Files", Option.of("Statistics"), fileStatsAdminPage);
        adminApp.registerAdminPage("Limited", Option.of("Statistics"), limitedFilesAdminPage);
        adminApp.registerAdminPage("Period summary", Option.of("Statistics"), periodSummaryAdminPage);
    }
}
