<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
        >

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:template match="page" mode="ajax">
        <xsl:apply-templates select="mpfs-file-info"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="mpfs-file-info"/>
    </xsl:template>

    <xsl:template match="mpfs-file-info">
        <div id="content" class="container">
            <h2>
                <a href="/mulca-proxy?mulca-id={meta/file_mid}&amp;content-type={mimetype}&amp;size={size}&amp;name={name}">
                    Download file
                </a>
            </h2>
            <h3>
                Name: <xsl:value-of select="name"/>
            </h3>
            <h3>
                Size: <xsl:value-of select="z:format-data-size(size)"/>
            </h3>
            <xsl:if test="meta/short_url">
                <h3>
                    Public link: <a href="{meta/short_url}"><xsl:value-of select="meta/short_url"/></a>
                </h3>
            </xsl:if>
            <xsl:if test="meta/pmid">
                <img src="/mulca-proxy?mulca-id={meta/pmid}" style="margin:auto;"/>
            </xsl:if>
            <pre>
                <xsl:value-of select="z:dump(.)"/>
            </pre>
        </div>
    </xsl:template>

</xsl:stylesheet>
