<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="limits" select="/page/content/limits"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/file-stat/FileStatAdminPage.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>File stat</h2>
            <form action="/z/file-stat" class="form-search">
                <table>
                    <tr>
                        <td>
                            Hid / Folder Hash:
                        </td>
                        <td>
                            <input type="text" name="id" placeholder="Hid/Folder hash" class="search-query"
                                   value="{id}"/>
                        </td>

                        <td>
                            Type:
                        </td>
                        <td>
                            <select name="type">
                                <option value="hid">
                                    <xsl:if test="type = 'hid'">
                                        <xsl:attribute name="selected"/>
                                    </xsl:if>
                                    HID
                                </option>
                                <option value="hash">
                                    <xsl:if test="type = 'hash'">
                                        <xsl:attribute name="selected"/>
                                    </xsl:if>
                                    HASH
                                </option>
                            </select>
                        </td>

                        <td>
                            Periods:
                        </td>
                        <td>
                            <input type="number" name="periods" placeholder="31" class="search-query input-mini">
                                <xsl:attribute name="value">
                                    <xsl:if test="count(limits/key) = 0">7</xsl:if>
                                    <xsl:if test="count(limits/key) != 0">
                                        <xsl:value-of select="count(limits/key)"/>
                                    </xsl:if>
                                </xsl:attribute>
                            </input>
                        </td>
                        <td>
                            <button type="submit" class="btn">Find</button>
                        </td>
                    </tr>
                </table>
            </form>
            <xsl:if test="id">
                <table class="table">
                    <xsl:apply-templates select="stats">
                        <xsl:sort select="key" order="descending"/>
                    </xsl:apply-templates>
                </table>
                <xsl:if test="type = 'hid'">
                    <div id="file-info" class="file-info" data-id="{id}"/>
                </xsl:if>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="stats">
        <xsl:variable name="key" select="key"/>
        <tr>
            <td width="30%">
                <xsl:value-of select="key"/>
            </td>
            <td>
                <xsl:variable name="current-limits" select="$limits[key=$key]/value"/>
                <xsl:if test="$current-limits/public-blocked = 'true'">
                    <span class="label label-important">
                        public blocked
                    </span>
                    <br/>
                </xsl:if>
                <xsl:if test="$current-limits/auth-blocked = 'true'">
                    <span class="label label-important">
                        auth blocked
                    </span>
                    <br/>
                </xsl:if>
                <xsl:apply-templates select="value"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="limit-mark">
        <span class="label label-warning">
            limited
        </span>
        <xsl:text> </xsl:text>
    </xsl:template>

    <xsl:template match="value">
        <xsl:if test="position() != 1">
            <hr/>
        </xsl:if>
        <xsl:variable name="key" select="../key"/>
        <xsl:variable name="channel" select="key"/>
        <xsl:variable name="current-limits" select="$limits[key=$key]/value"/>
        <xsl:if test="value/p">
            <xsl:if test="$current-limits/public-limited[key=$channel]">
                <xsl:call-template name="limit-mark"/>
            </xsl:if>
            <span title="{value/p/t}">
                <xsl:value-of select="concat(key, '.public.traffic: ', z:format-data-size(value/p/t))"/>
            </span>
            <br/>
            <xsl:if test="$current-limits/public-limited[key=$channel]">
                <xsl:call-template name="limit-mark"/>
            </xsl:if>
            <xsl:value-of select="concat(key, '.public.views: ', value/p/c)"/>
            <br/>
        </xsl:if>
        <xsl:if test="value/a">
            <xsl:if test="$current-limits/auth-limited[key=$channel]">
                <xsl:call-template name="limit-mark"/>
            </xsl:if>
            <span title="{value/a/t}">
                <xsl:value-of select="concat(key, '.auth.traffic: ', z:format-data-size(value/a/t))"/>
            </span>
            <br/>
            <xsl:if test="$current-limits/auth-limited[key=$channel]">
                <xsl:call-template name="limit-mark"/>
            </xsl:if>
            <xsl:value-of select="concat(key, '.auth.views: ', value/a/c)"/>
            <br/>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
