<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
        >

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="limits" select="/page/content/limits"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Limited files. <small>Total blocked:<xsl:value-of select="blocked-files-count"/></small></h2>
            <table class="table table-bordered">
                <tr>
                    <td>
                        Hid / Folder hash
                    </td>
                    <td>
                        Type
                    </td>
                    <td>
                        Limited info
                    </td>
                </tr>
                <xsl:apply-templates select="limited">
                    <xsl:sort select="last-time" order="descending"/>
                </xsl:apply-templates>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="limited">
        <tr>
            <td>
                <a href="/z/file-stat?id={key}&amp;type={type}">
                    <xsl:value-of select="key"/>
                </a>
            </td>
            <td>
                <xsl:value-of select="type"/>
            </td>
            <td>
                <xsl:if test="value/public-blocked = 'true'">
                    <span class="label label-important">
                        public blocked
                    </span>
                    <br/>
                </xsl:if>
                <xsl:if test="value/auth-blocked = 'true'">
                    <span class="label label-important">
                        auth blocked
                    </span>
                    <br/>
                </xsl:if>
                <xsl:for-each select="value/public-limited">
                    <xsl:value-of select="concat('public.', key)"/>
                    :
                    <xsl:value-of select="z:format-date-time(value)"/>
                    <br/>
                </xsl:for-each>
                <xsl:for-each select="value/auth-limited">
                    <xsl:value-of select="concat('auth.', key)"/>
                    :
                    <xsl:value-of select="z:format-date-time(value)"/>
                    <br/>
                </xsl:for-each>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
