<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="limits" select="/page/content/limits"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Limited files. <small>Total blocked:<xsl:value-of select="blocked-files-count"/></small></h2>
            <form action="/z/limited-files" class="form-search">
                <table>
                    <tr>
                        <td>
                            Periods:
                        </td>
                        <td>
                            <input type="number" name="periods" placeholder="31" class="search-query input-mini" value="{periods}"/>
                        </td>
                        <td>
                            <button type="submit" class="btn">Refresh</button>
                        </td>
                    </tr>
                </table>
            </form>

            <table class="table table-bordered">
                <tr>
                    <td>
                        Period
                    </td>
                    <td>
                        Limited files count
                    </td>
                </tr>
                <xsl:apply-templates select="limited">
                    <xsl:sort select="key" order="descending"/>
                </xsl:apply-templates>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="limited">
        <tr>
            <td>
                <a href="limited-files/period?period={key}">
                    <xsl:value-of select="key"/>
                </a>
            </td>
            <td>
                <a href="limited-files/period?period={key}">
                    <xsl:value-of select="value"/>
                </a>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
