package ru.yandex.chemodan.app.stat.admin;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.mediatype.MediatypeLimits;
import ru.yandex.chemodan.app.stat.limits.mediatype.MediatypeLimitsRegistry;
import ru.yandex.chemodan.app.stat.web.ConvertToDataSize;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Lev Tolmachev
 */
@ActionContainer
public class MediatypeLimitsAdminPage {

    private final MediatypeLimitsRegistry mediatypeLimitsRegistry;
    private final LimitsManager limitsManager;

    public MediatypeLimitsAdminPage(MediatypeLimitsRegistry mediatypeLimitsRegistry, LimitsManager limitsManager) {
        this.mediatypeLimitsRegistry = mediatypeLimitsRegistry;
        this.limitsManager = limitsManager;
    }

    @ZAction(file = "MediatypeLimitsAdminPage.xsl", defaultAction = true)
    @Path("/mediatype-limits")
    public MediatypeLimitsList mediatypeLimitsList() {
        return new MediatypeLimitsList(mediatypeLimitsRegistry.getLimits());
    }

    @ZAction(engineId = "text")
    @Path("/mediatype-limits/set")
    public EmptyContentPojo setMediatypeLimits(
            @RequestParam("mediatype")
            String mediatype,
            @RequestParam("channel")
            String channel,
            @RequestParam("auth")
            boolean auth,
            @RequestParam(value = "traffic", ignoreEmpty = true, customConverter = ConvertToDataSize.class)
            Option<DataSize> traffic,
            @RequestParam(value = "views", ignoreEmpty = true)
            Option<Long> views)
    {
        limitsManager.changeMediatypeChannelLimits(mediatype, channel, auth, traffic, views);
        throw new ZRedirectException("/mediatype-limits");
    }


    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    @XmlRootElement(name = "content")
    static final class MediatypeLimitsList {
        public final ListF<MediatypeLimits> limits;

        public MediatypeLimitsList(ListF<MediatypeLimits> limits) {
            this.limits = limits;
        }
    }
}
