package ru.yandex.chemodan.app.stat.admin;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.client.HttpClient;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.random.Random2;

/**
 * @author Lev Tolmachev
 */
public class MulcaProxyServlet extends HttpServlet {

    private final ListF<MulcaClient> mulcaClients;

    public MulcaProxyServlet(ListF<String> mulcaHosts, HttpClient mulcaHttpClient, String mulcaService,
            String mulcaNamespace)
    {
        mulcaClients = mulcaHosts.map(s ->
                MulcaClient.custom(mulcaHttpClient, buildMulcaGateUrl(s)).withService(mulcaService)
                        .withNamespace(mulcaNamespace).build());
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MulcaId mulcaId = MulcaId.fromSerializedString(req.getParameter("mulca-id"));
        String contentType = req.getParameter("content-type");
        Option<String> fileName = Option.ofNullable(req.getParameter("name"));
        Option<Long> size = Option.ofNullable(req.getParameter("size")).map(Cf.Long.parseF());

        if (contentType != null) {
            resp.setContentType(contentType);
        }
        if (size.isPresent() && size.get() < Integer.MAX_VALUE) {
            resp.setContentLength(size.get().intValue());
        }
        if (fileName.isPresent()) {
            resp.addHeader("Content-Disposition", "attachment; filename=\"" + fileName.get() + "\"");
        }
        for (int i = 0; i < 3; ++i) {
            try {
                MulcaClient mulcaClient = Random2.R.randomElement(mulcaClients);
                mulcaClient.download(mulcaId).readTo(resp.getOutputStream());
            } catch (RuntimeException e) {
                continue;
            }
            break;
        }
    }

    private String buildMulcaGateUrl(String mulcaHost) {
        return "http://" + mulcaHost + ":10010/gate";
    }
}
