package ru.yandex.chemodan.app.stat.admin;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.TimeUtils;
import ru.yandex.chemodan.app.stat.storage.PeriodStats;
import ru.yandex.chemodan.app.stat.storage.PeriodSummaryStatsDao;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Lev Tolmachev
 */
@ActionContainer
public class PeriodSummaryAdminPage {

    private final Duration period;
    private final PeriodSummaryStatsDao periodSummaryStatsDao;

    public PeriodSummaryAdminPage(Duration period, PeriodSummaryStatsDao periodSummaryStatsDao) {
        this.period = period;
        this.periodSummaryStatsDao = periodSummaryStatsDao;
    }

    @ZAction(defaultAction = true, file = "PeriodSummaryAdminPage.xsl")
    @Path("/period-summary")
    public Content index(
            @RequestParam(value = "periods")
            Option<Integer> periods)
    {
        MapF<Instant, PeriodStats> stats = Cf.hashMap();
        InstantInterval interval = TimeUtils.getCurrentPeriod(period);
        for (int i = 0; i < periods.getOrElse(7); i++) {
            stats.put(interval.getStart(), periodSummaryStatsDao.getPeriodStats(interval.getStart()));
            interval = TimeUtils.getPreviousPeriod(interval);
        }
        return new Content(stats);
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static final class Content {
        private final MapF<Instant, PeriodStats> stats;

        private Content(MapF<Instant, PeriodStats> stats) {
            this.stats = stats;
        }
    }
}
