<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
        >

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="limits" select="/page/content/limits"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Period stats</h2>
            <table class="table table-bordered">
                <tr>
                    <td>
                        Period
                    </td>
                    <td>
                        stats
                    </td>
                </tr>
                <xsl:apply-templates select="stats">
                    <xsl:sort select="key" order="descending"/>
                </xsl:apply-templates>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="stats">
        <tr>
            <td width="30%">
                <xsl:value-of select="format-dateTime(key, '[Y0001].[M01].[D01]')"/>
            </td>
            <td>
                <xsl:for-each select="value/cs">
                    <h4><xsl:value-of select="key"/></h4>
                    count: <xsl:value-of select="
                    (if (value/p/c) then number(value/p/c) else number(0)) +
                    (if (value/a/c) then number(value/a/c) else number(0))"/>
                    <br/>
                    traffic: <xsl:value-of select="z:format-data-size(
                     (if (value/p/t) then number(value/p/t) else number(0)) +
                     (if (value/a/t) then number(value/a/t) else number(0)))"/><br/>
                    <br/>
                    public.count: <xsl:value-of select="value/p/c"/><br/>
                    public.traffic: <xsl:value-of select="z:format-data-size(value/p/t)"/><br/>
                    <br/>
                    auth.count: <xsl:value-of select="value/a/c"/><br/>
                    auth.traffic: <xsl:value-of select="z:format-data-size(value/a/t)"/><br/>
                </xsl:for-each>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
