package ru.yandex.chemodan.app.stat.admin;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistEntry;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.app.stat.storage.DownloadStatType;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Lev Tolmachev
 */
@ActionContainer
public class WhitelistAdminPage {
    private static final Logger logger = LoggerFactory.getLogger(WhitelistAdminPage.class);

    private final WhitelistRegistry whitelistRegistry;

    public WhitelistAdminPage(WhitelistRegistry whitelistRegistry) {
        this.whitelistRegistry = whitelistRegistry;
    }

    @ZAction(file = "WhitelistAdminPage.xsl", defaultAction = true)
    @Path("/whitelist")
    public Whitelist whitelist() {
        return new Whitelist(whitelistRegistry.getWhitelist());
    }

    @ZAction(engineId = "text")
    @Path("/whitelist/add")
    public EmptyContentPojo addToWhitelist(
            @RequestParam(value = "id") String id,
            @RequestParam("type") DownloadStatType type,
            @RequestParam("description") String description)
    {
        whitelistRegistry.addToWhiteList(new DownloadStatId(id, type), description);
        throw new ZRedirectException("/whitelist");
    }

    @ZAction(engineId = "text")
    @Path("/whitelist/remove")
    public EmptyContentPojo removeFromWhitelist(
            @RequestParam(value = "id") String id,
            @RequestParam("type") DownloadStatType type)
    {
        whitelistRegistry.removeFromWhiteList(new DownloadStatId(id, type));
        throw new ZRedirectException("/whitelist");
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    @XmlRootElement(name = "content")
    private static final class Whitelist {
        @BenderPart(wrapperName = "whitelist", name = "lines")
        public final SetF<WhitelistLine> lines;

        public Whitelist(SetF<WhitelistEntry> entries) {
            this.lines = entries.map(WhitelistLine::new).unique();
        }
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static final class WhitelistLine {
        public final String id;
        public final DownloadStatType type;
        public final String description;

        public WhitelistLine(WhitelistEntry entry) {
            this.id = entry.id.getIdString();
            this.type = entry.id.getType();
            this.description = entry.description;
        }
    }

}
