<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Whitelist</h2>
            <button class="btn btn-primary" data-toggle="modal" data-target="#add-to-whitelist" >
                Add file to whitelist
            </button>
            <br/>
            <br/>
            <table class="table table-bordered">
                <tr>
                    <th class="lead">
                        HID / Folder hash
                    </th>
                    <th class="lead">
                        Type
                    </th>
                    <th class="lead">
                        Description
                    </th>
                    <th class="lead">
                        Actions
                    </th>
                </tr>
                <xsl:apply-templates select="whitelist/lines">
                    <xsl:sort select="id"/>
                </xsl:apply-templates>
            </table>

            <div class="modal fade" id="add-to-whitelist" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>
                            <h3>Whitelist entry</h3>
                        </div>
                        <form class="form-horizontal" action="/z/whitelist/add">
                            <div class="modal-body">
                                <div class="control-group">
                                    <label class="control-label" for="inputId">Hid / Folder hash</label>
                                    <div class="controls">
                                        <input type="text" name="id" id="inputId" placeholder="HID or Folder hash"/>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputType">Type</label>
                                    <div class="controls">
                                        <select name="type" id="inputType">
                                            <option selected="selected" value="hid">HID</option>
                                            <option value="hash">HASH</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputDescription">Description</label>
                                    <div class="controls">
                                        <input type="text" name="description" id="inputDescription" placeholder="Very important file"/>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Add to whitelist</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="lines">
        <tr>
            <td>
                <xsl:value-of select="id"/>
            </td>
            <td>
                <xsl:value-of select="type"/>
            </td>
            <td>
                <xsl:value-of select="description"/>
            </td>
            <td>
                <form class="form-horizontal" action="/z/whitelist/remove">
                    <input name="id" type="hidden" value="{id}"/>
                    <input name="type" type="hidden" value="{type}"/>
                    <button type="submit" class="btn btn-primary">Remove</button>
                </form>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
