<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
        xmlns:z="urn:zscript-functions"
        exclude-result-prefixes="#all">

    <xsl:function name="z:format-data-size">
        <xsl:param name="bytes"/>
        <xsl:choose>
            <xsl:when test="$bytes >= 1024 * 1024 * 1024">
                <xsl:value-of select="concat($bytes idiv 1024 idiv 1024 idiv 1024, 'Gb')"/>
            </xsl:when>
            <xsl:when test="$bytes >= 1024 * 1024">
                <xsl:value-of select="concat($bytes idiv 1024 idiv 1024, 'Mb')"/>
            </xsl:when>
            <xsl:when test="$bytes >= 1024">
                <xsl:value-of select="concat($bytes idiv 1024, 'Kb')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$bytes"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
</xsl:stylesheet>
