package ru.yandex.chemodan.app.stat.antiporno;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DuplicateKeyException;
import org.bson.types.Binary;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.stat.storage.util.MpfsHidMarshaller;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.mongo.bender.MongoBenderUtils;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class AntipornoCheckedFilesDao {
    private static final Logger logger = LoggerFactory.getLogger(AntipornoCheckedFilesDao.class);

    private static final BenderConfiguration benderConfiguration = new BenderConfiguration(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(MpfsHid.class, new MpfsHidMarshaller())
                    .build()
    );

    private static final BenderJsonSerializer<CheckedFile> serializer =
            MongoBenderUtils.createSerializer(benderConfiguration, CheckedFile.class);

    private final DBCollection collection;

    public AntipornoCheckedFilesDao(DBCollection collection) {
        this.collection = collection;
    }

    public void insert(MpfsHid hid) {
        try {
            collection.insert(MongoBenderUtils.serialize(serializer, new CheckedFile(hid)));
        } catch (DuplicateKeyException e) {
            logger.info("Failed to insert file, it was already checked for porno");
        }
    }

    public boolean contains(MpfsHid hid) {
        return collection.find(new BasicDBObject("hid", new Binary((byte) 2, hid.data))).hasNext();
    }

    @BenderBindAllFields
    private static class CheckedFile {
        public final Instant created;
        public final MpfsHid hid;

        public CheckedFile(MpfsHid hid) {
            this.created = Instant.now();
            this.hid = hid;
        }
    }
}
