package ru.yandex.chemodan.app.stat.antiporno;

import java.util.List;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.stat.antiporno.processors.AbstractDetector;
import ru.yandex.chemodan.app.stat.antiporno.processors.AbstractFilter;
import ru.yandex.chemodan.app.stat.moderate.ModerationContextConfiguration;
import ru.yandex.chemodan.app.stat.moderate.ModerationQueueClient;

/**
 * @author metal
 */
@Configuration
@Import({
        AntipornoProcessorsContextConfiguration.class,
        ModerationContextConfiguration.class,
})
public class AntipornoContextConfiguration {

    @Bean
    public AntipornoCheckedFilesDao antipornoCheckedFilesDao(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.antiporno.db.name}")
            String dbName,
            @Value("${antifo.antiporno.checked.files.mpfs.collection.name}")
            String collectionName)
    {
        return new AntipornoCheckedFilesDao(statMongoClient.getDB(dbName).getCollection(collectionName));
    }

    @Bean
    public PornoChecker pornoChecker(
            List<AbstractFilter> filters,
            List<AbstractDetector> detectors,
            @Value("${antifo.antiporno.score.max.limit}")
            double antiPornoScoreLimit,
            ModerationQueueClient moderationQueueClient,
            AntipornoCheckedFilesDao antipornoCheckedFilesDao)
    {
        return new PornoChecker(filters, detectors, moderationQueueClient, antipornoCheckedFilesDao, antiPornoScoreLimit);
    }
}
