package ru.yandex.chemodan.app.stat.antiporno;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.stat.antiporno.collectors.MpfsInfoCollector;
import ru.yandex.chemodan.app.stat.antiporno.collectors.MpfsResourceInfoCollector;
import ru.yandex.chemodan.app.stat.antiporno.collectors.PublicationTimeCollector;
import ru.yandex.chemodan.app.stat.antiporno.collectors.UserRegistrationTimeCollector;
import ru.yandex.chemodan.app.stat.antiporno.processors.FileNameFilter;
import ru.yandex.chemodan.app.stat.antiporno.processors.MediaTypeFilter;
import ru.yandex.chemodan.app.stat.antiporno.processors.NameDetector;
import ru.yandex.chemodan.app.stat.antiporno.processors.PreviewRecognitionDetector;
import ru.yandex.chemodan.app.stat.antiporno.processors.TimeDetector;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author metal
 */
@Configuration
public class AntipornoProcessorsContextConfiguration {
    @Bean
    public MpfsInfoCollector mpfsInfoCollector() {
        return new MpfsInfoCollector();
    }

    @Bean
    public MpfsResourceInfoCollector mpfsResourceInfoCollector() {
        return new MpfsResourceInfoCollector();
    }

    @Bean
    public PublicationTimeCollector publicationTimeCollector() {
        return new PublicationTimeCollector();
    }

    @Bean
    public UserRegistrationTimeCollector userRegistrationTimeCollector() {
        return new UserRegistrationTimeCollector();
    }

    @Bean
    public MediaTypeFilter mediaTypeFilter(MpfsInfoCollector mpfsInfoCollector,
            MpfsResourceInfoCollector mpfsResourceInfoCollector)
    {
        return new MediaTypeFilter(Cf.list(mpfsInfoCollector, mpfsResourceInfoCollector));
    }

    @Bean
    public FileNameFilter fileNameFilter(MpfsInfoCollector mpfsInfoCollector) {
        return new FileNameFilter(Cf.list(mpfsInfoCollector));
    }

    @Bean
    public NameDetector nameDetector(MpfsInfoCollector mpfsInfoCollector) {
        return new NameDetector(Cf.list(mpfsInfoCollector));
    }

    @Bean
    public PreviewRecognitionDetector previewRecognitionDetector(
            @Value("${antifo.antiporno.detectors.preview.recognition.url}")
            String recognizerUrl,
            MpfsInfoCollector mpfsInfoCollector,
            MpfsResourceInfoCollector mpfsResourceInfoCollector)
    {
        return new PreviewRecognitionDetector(recognizerUrl, Cf.list(mpfsInfoCollector, mpfsResourceInfoCollector),
                yavisionHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("yavision")
    public HttpClientConfigurator yavisionHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public TimeDetector timeDetector(MpfsInfoCollector mpfsInfoCollector,
            PublicationTimeCollector publicationTimeCollector,
            UserRegistrationTimeCollector userRegistrationTimeCollector)
    {
        return new TimeDetector(Cf.list(mpfsInfoCollector, publicationTimeCollector, userRegistrationTimeCollector));
    }
}
