package ru.yandex.chemodan.app.stat.antiporno;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsHid;

/**
 * @author metal
 */
public class AntipornoTestData {
    public static PornoCheckRecord createEmptyPublicFileRecord() {
        return createEmptyRecord(new MpfsHid("a305d5b0a0b1598716806c724b663166"));
    }

    public static PornoCheckRecord createEmptyFileInPublicDirectoryRecord() {
        PornoCheckRecord record = createEmptyRecord(new MpfsHid("fe5e9045c597a57c26271cc388bd81fd"));
        record.data.put("hash", "d8HU2fcR0FLVh0Bk/pYLoQdMmSY5wxJHdFT5K43yA8U=:/file.png");
        return record;
    }

    public static PornoCheckRecord createEmptyPrivateFileRecord() {
        return createEmptyRecord(new MpfsHid("bb33b216c520006a5ce8f62728951fac"));
    }

    public static PornoCheckRecord createEmptyRecord(MpfsHid hid) {
        return new PornoCheckRecord(hid, Option.empty(), Option.empty());
    }
}
