package ru.yandex.chemodan.app.stat.antiporno;

import java.util.List;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.stat.antiporno.processors.AbstractDetector;
import ru.yandex.chemodan.app.stat.antiporno.processors.AbstractFilter;
import ru.yandex.chemodan.app.stat.antiporno.processors.FileNameFilter;
import ru.yandex.chemodan.app.stat.antiporno.processors.NameDetector;
import ru.yandex.chemodan.app.stat.moderate.ModerationQueueClient;
import ru.yandex.chemodan.mpfs.MpfsHid;

/**
 * @author metal
 */
@Configuration
public class AntipornoTestsConfig {
    public static final MpfsHid FAKE_HID_1 = new MpfsHid("hid-fake-1");
    public static final MpfsHid FAKE_HID_2 = new MpfsHid("hid-fake-2");

    @Bean
    public ModerationQueueClient moderationQueueClient() {
        ModerationQueueClient mock = Mockito.mock(ModerationQueueClient.class);

        Mockito
                .when(mock.containsAntipornoDetectedFile(Matchers.eq(FAKE_HID_1)))
                .thenReturn(false)
                .thenReturn(false)
                .thenReturn(true);

        Mockito
                .when(mock.containsAntipornoDetectedFile(Matchers.eq(FAKE_HID_2)))
                .thenReturn(false)
                .thenReturn(false);

        Mockito.doNothing().when(mock).addToQueue(Matchers.any());

        return mock;
    }

    @Bean
    public AntipornoCheckedFilesDao antipornoCheckedFilesDao() {
        AntipornoCheckedFilesDao mock = Mockito.mock(AntipornoCheckedFilesDao.class);

        Mockito
                .when(mock.contains(Matchers.eq(FAKE_HID_1)))
                .thenReturn(false)
                .thenReturn(false);

        Mockito
                .when(mock.contains(Matchers.eq(FAKE_HID_2)))
                .thenReturn(false)
                .thenReturn(true);

        Mockito.doNothing().when(mock).insert(Matchers.any());

        return mock;
    }

    @Bean
    public FileNameFilter fileNameFilter() {
        return new FileNameFilter(Cf.list());
    }

    @Bean
    public NameDetector nameDetector() {
        return new NameDetector(Cf.list());
    }

    @Bean
    public PornoChecker pornoChecker(
            List<AbstractFilter> filters,
            List<AbstractDetector> detectors,
            @Value("${antifo.antiporno.score.max.limit}")
            double antiPornoScoreLimit,
            ModerationQueueClient moderationQueueClient,
            AntipornoCheckedFilesDao antipornoCheckedFilesDao)
    {
        return new PornoChecker(filters, detectors, moderationQueueClient, antipornoCheckedFilesDao, antiPornoScoreLimit);
    }
}
