package ru.yandex.chemodan.app.stat.antiporno;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.antiporno.scores.Score;
import ru.yandex.chemodan.mpfs.MpfsHid;

/**
 * @author metal
 */
public class PornoCheckRecord {
    public final MapF<String, Object> data = Cf.hashMap();
    public final ListF<Score> scores = Cf.arrayList();
    public boolean addToCheckedFilesCollection = true;
    public volatile boolean userIsBlocked = false;

    public PornoCheckRecord(MpfsHid hid, Option<String> hash, Option<String> name) {
        data.put("hid", hid.toString());
        if (hash.isPresent()) {
            data.put("hash", hash.get());
        }
        if (name.isPresent()) {
            data.put("name", name.get());
        }
    }

    public <T> Option<T> getTypedData(String key) {
        return data.getO(key).cast();
    }
}
