package ru.yandex.chemodan.app.stat.antiporno.collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class MpfsInfoCollector implements DataCollector {
    private static final Logger logger = LoggerFactory.getLogger(MpfsInfoCollector.class);

    @Autowired
    private MpfsClient mpfsClient;

    @Override
    public void collect(PornoCheckRecord record) {
        if (!record.data.containsKeyTs("hasMpfsFileInfo")) {
            String hid = record.<String>getTypedData("hid").get();
            try {
                MpfsFileInfo info = mpfsClient.getFileInfoByHid(new MpfsHid(hid));
                record.data.put("hasMpfsFileInfo", true);
                if (!record.data.containsKeyTs("name") && info.name.isPresent()) {
                    record.data.put("name", info.name.get());
                }
                if (!record.data.containsKeyTs("hash") && info.getMeta().getPublicHash().isPresent()) {
                    record.data.put("hash", info.getMeta().getPublicHash().get());
                }
                if (info.getMeta().getShortUrl().isPresent()) {
                    record.data.put("short_url", info.getMeta().getShortUrl().get());
                }
                if (info.getMeta().getPmid().isPresent()) {
                    String previewUrl = mpfsClient.generateZaberunUrl(
                            info.getMeta().getPmid().get(),
                            info.name.get(),
                            "preview",
                            info.getMeta().getUid(),
                            Option.empty(),
                            Option.empty(),
                            Option.empty(),
                            Option.empty(),
                            Option.empty(),
                            Option.empty(),
                            Option.of("S"),
                            Option.empty(),
                            Option.empty(),
                            Option.of(600),
                            Option.of(0),
                            Option.of(true),
                            Option.empty()
                    );
                    record.data.put("preview", previewUrl);
                }
                record.data.put("type", "file");
            } catch (Exception e) {
                logger.error("Can't get mpfs info data for anti porno checking; {}", e);
                record.addToCheckedFilesCollection = false;
            }
        }
    }
}
