package ru.yandex.chemodan.app.stat.antiporno.collectors;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class MpfsInfoCollectorTest extends AbstractAntipornoTest {

    @Autowired
    private MpfsInfoCollector mpfsInfoCollector;

    @Test
    public void getPublicFileInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPublicFileRecord();
        mpfsInfoCollector.collect(record);

        Assert.isTrue(record.<Boolean>getTypedData("hasMpfsFileInfo").get());
        Assert.equals("public_2.png", record.data.getTu("name"));
        Assert.equals("file", record.data.getTu("type"));
        Assert.equals("2GVGda5OXC1nBV7fs7gfPTl9Ucs0vl0ZJqtpLtxcDLM=", record.data.getTu("hash"));
        Assert.isTrue(record.<String>getTypedData("short_url").get().contains("front.tst.clk.yandex.net"));

        String preview = record.<String>getTypedData("preview").get();
        Assert.isTrue(preview.contains("downloader.dst.yandex.ru"));
        Assert.isTrue(preview.contains("filename=public_2.png"));
    }

    @Test
    public void getPrivateFileInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPrivateFileRecord();
        mpfsInfoCollector.collect(record);

        Assert.isTrue(record.<Boolean>getTypedData("hasMpfsFileInfo").get());
        Assert.equals("private_2.jpg", record.data.getTu("name"));
        Assert.equals("file", record.data.getTu("type"));

        Assert.isFalse(record.data.containsKeyTs("hash"));
        Assert.isFalse(record.data.containsKeyTs("short_url"));

        String preview = record.<String>getTypedData("preview").get();
        Assert.isTrue(preview.contains("downloader.dst.yandex.ru"));
        Assert.isTrue(preview.contains("filename=private_2.jpg"));
    }
}
