package ru.yandex.chemodan.app.stat.antiporno.collectors;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.util.test.TestUser;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class MpfsResourceInfoCollectorTest extends AbstractAntipornoTest {

    @Autowired
    private MpfsInfoCollector mpfsInfoCollector;

    @Autowired
    private MpfsResourceInfoCollector mpfsResourceInfoCollector;

    @Test
    public void getPublicResourceInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPublicFileRecord();

        mpfsInfoCollector.collect(record);
        mpfsResourceInfoCollector.collect(record);

        Assert.isTrue(record.<Boolean>getTypedData("hasResourceInfo").get());
        Assert.equals("public_2.png", record.data.getTu("name"));
        Assert.equals("file", record.data.getTu("type"));
        Assert.equals("image", record.data.getTu("media_type"));

        Assert.equals(TestUser.uid2.toString(), record.data.getTu("uid"));

        Assert.isTrue(record.<String>getTypedData("short_url").get().contains("front.tst.clk.yandex.net"));

        String preview = record.<String>getTypedData("preview").get();
        Assert.isTrue(preview.contains("downloader.dst.yandex.ru"));
        Assert.isTrue(preview.contains("filename=public_2.png"));
    }

    @Test
    public void getPrivateResourceInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPrivateFileRecord();

        mpfsInfoCollector.collect(record);
        mpfsResourceInfoCollector.collect(record);

        Assert.isFalse(record.data.containsKeyTs("hasResourceInfo"));
        Assert.equals("private_2.jpg", record.data.getTu("name"));
        Assert.equals("file", record.data.getTu("type"));

        Assert.isFalse(record.data.containsKeyTs("media_type"));
        Assert.isFalse(record.data.containsKeyTs("uid"));
        Assert.isFalse(record.data.containsKeyTs("short_url"));

        String preview = record.<String>getTypedData("preview").get();
        Assert.isTrue(preview.contains("downloader.dst.yandex.ru"));
        Assert.isTrue(preview.contains("filename=private_2.jpg"));
    }

    @Test
    public void getResourceInPublicDirectoryInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyFileInPublicDirectoryRecord();

        mpfsInfoCollector.collect(record);
        mpfsResourceInfoCollector.collect(record);

        Assert.isTrue(record.<Boolean>getTypedData("hasResourceInfo").get());
        Assert.equals("file.png", record.data.getTu("name"));
        Assert.equals("file", record.data.getTu("type"));
        Assert.equals("image", record.data.getTu("media_type"));

        Assert.equals(TestUser.uid2.toString(), record.data.getTu("uid"));

        Assert.isTrue(record.<String>getTypedData("short_url").get().contains("front.tst.clk.yandex.net"));

        String preview = record.<String>getTypedData("preview").get();
        Assert.isTrue(preview.contains("downloader.dst.yandex.ru"));
        Assert.isTrue(preview.contains("filename=file.png"));
    }

}
