package ru.yandex.chemodan.app.stat.antiporno.collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;


/**
 * @author metal
 */
public class PublicationTimeCollector implements DataCollector {
    private static final Logger logger = LoggerFactory.getLogger(PublicationTimeCollector.class);

    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    private MpfsClient mpfsClient;

    @Override
    public void collect(PornoCheckRecord record) {
        if (record.data.containsKeyTs("hash") && !record.data.containsKeyTs("hasPublicationTime")) {
            String hash = record.<String>getTypedData("hash").get();
            try {
                String publicFileAddressString = mpfsClient.getPublicFileAddress(hash);
                JsonNode publicFileAddress = objectMapper.readTree(publicFileAddressString);

                record.data.put("hasPublicationTime", true);
                record.data.put("ptime", publicFileAddress.get("result").get("ptime").asLong());
                if (!record.data.containsKeyTs("uid")) {
                    record.data.put("uid", publicFileAddress.get("result").get("uid").asText());
                }
            } catch (Exception e) {
                logger.error("Can't get uid and publication time for anti porno checking, hash={} : {}", hash, e);
                record.addToCheckedFilesCollection = false;
            }
        }
    }
}
