package ru.yandex.chemodan.app.stat.antiporno.collectors;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.util.test.TestUser;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class PublicationTimeCollectorTest extends AbstractAntipornoTest {

    @Autowired
    private MpfsInfoCollector mpfsInfoCollector;

    @Autowired
    private PublicationTimeCollector publicationTimeCollector;

    @Test
    public void getPublicFilePublicationInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPublicFileRecord();

        mpfsInfoCollector.collect(record);
        publicationTimeCollector.collect(record);

        Assert.equals(true, record.data.getTu("hasPublicationTime"));
        Assert.equals(TestUser.uid2.toString(), record.data.getTu("uid"));
        Assert.equals(1447423777L, record.data.getTu("ptime"));
    }

    @Test
    public void getPrivateFilePublicationInfoData() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPrivateFileRecord();

        mpfsInfoCollector.collect(record);
        publicationTimeCollector.collect(record);

        Assert.isFalse(record.data.containsKeyTs("hasPublicationTime"));
        Assert.isFalse(record.data.containsKeyTs("uid"));
        Assert.isFalse(record.data.containsKeyTs("ptime"));
    }
}
