package ru.yandex.chemodan.app.stat.antiporno.collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class UserRegistrationTimeCollector implements DataCollector {
    private static final Logger logger = LoggerFactory.getLogger(UserRegistrationTimeCollector.class);

    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    private MpfsClient mpfsClient;

    @Override
    public void collect(PornoCheckRecord record) {
        if (record.data.containsKeyTs("uid") && !record.data.containsKeyTs("reg_time")) {
            String uid = record.<String>getTypedData("uid").get();
            try {
                PassportUid passportUid = PassportUid.cons(Long.parseLong(uid));
                String userInfoString = mpfsClient.getUserInfo(MpfsUser.of(passportUid));
                JsonNode userInfo = objectMapper.readTree(userInfoString);
                record.data.put("reg_time", userInfo.get("reg_time").asLong());
                record.userIsBlocked = isUserBlocked(userInfo);
            } catch (Exception e) {
                logger.error("Can't get registration time for anti porno checking, uid=" + uid, e);
                record.addToCheckedFilesCollection = false;
            }
        }
    }

    private static boolean isUserBlocked(JsonNode userInfo) {
        return Option.ofNullable(userInfo.get("blocked"))
                .map(JsonNode::asLong)
                .isSome(1L);
    }
}
