package ru.yandex.chemodan.app.stat.antiporno.collectors;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class UserRegistrationTimeCollectorTest extends AbstractAntipornoTest {

    @Autowired
    private MpfsInfoCollector mpfsInfoCollector;

    @Autowired
    private PublicationTimeCollector publicationTimeCollector;

    @Autowired
    private UserRegistrationTimeCollector userRegistrationTimeCollector;

    @Test
    public void getUserRegistrationTimeFromPublicFile() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPublicFileRecord();

        mpfsInfoCollector.collect(record);
        publicationTimeCollector.collect(record);
        userRegistrationTimeCollector.collect(record);

        Assert.equals(1472191947L, record.data.getTu("reg_time"));
    }

    @Test
    public void getUserRegistrationTimeFromPrivateFile() {
        PornoCheckRecord record = AntipornoTestData.createEmptyPrivateFileRecord();

        mpfsInfoCollector.collect(record);
        publicationTimeCollector.collect(record);
        userRegistrationTimeCollector.collect(record);

        Assert.isFalse(record.data.containsKeyTs("reg_time"));
    }
}
