package ru.yandex.chemodan.app.stat.antiporno.processors;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.app.stat.antiporno.collectors.DataCollector;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public abstract class AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProcessor.class);

    private final ListF<DataCollector> dataCollectors;

    protected boolean ignorePrivateFiles = true;

    public AbstractProcessor(ListF<DataCollector> dataCollectors) {
        this.dataCollectors = dataCollectors;
    }

    public boolean process(PornoCheckRecord record) {
        collectStartingData(record);

        if (record.userIsBlocked) {
            logger.info("Skip processing file with hid={}, because user#{} is blocked",
                    record.data.getOrElse("hid", ""),
                    record.data.getOrElse("uid", "")
            );
            record.addToCheckedFilesCollection = false;
            return false;
        }

        if (ignorePrivateFiles && !record.data.containsKeyTs("hash")) {
            logger.info("File with hid {} does not have public_hash", record.data.getTs("hid"));
            record.addToCheckedFilesCollection = false;
            return false;
        }

        return processInner(record);
    }

    protected abstract boolean processInner(PornoCheckRecord record);

    private void collectStartingData(PornoCheckRecord record) {
        for (DataCollector dataCollector : dataCollectors) {
            dataCollector.collect(record);
            if (record.userIsBlocked) {
                return;
            }
        }
    }
}
