package ru.yandex.chemodan.app.stat.antiporno.processors;

import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.app.stat.antiporno.collectors.DataCollector;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class FileNameFilter extends AbstractFilter {
    private static final Logger logger = LoggerFactory.getLogger(FileNameFilter.class);

    private final DynamicProperty<ListF<String>> skippedRegexps = new DynamicProperty<>(
            "antifo.antiporno.filters.name.skipped.regexps",
            Cf.arrayList("\\.apk$"));

    public FileNameFilter(ListF<DataCollector> dataCollectors) {
        super(dataCollectors);
        ignorePrivateFiles = false;
    }

    @Override
    protected boolean filter(PornoCheckRecord record) {
        return !record.data.containsKeyTs("name") || !needToSkip(record.<String>getTypedData("name").get());
    }

    private boolean needToSkip(String name) {
        for (String skippedRegexp : skippedRegexps.get()) {
            if (Pattern.compile(skippedRegexp, Pattern.CASE_INSENSITIVE).matcher(name).find()) {
                logger.info("File was skipped because name '{}' contains regexp '{}'", name, skippedRegexp);
                return true;
            }
        }
        return false;
    }
}
