package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class FileNameFilterTest extends AbstractAntipornoTest {

    @Autowired
    private FileNameFilter fileNameFilter;

    private PornoCheckRecord record;

    @Before
    public void initRecord() {
        record = AntipornoTestData.createEmptyPublicFileRecord();
        record.data.put("hasMpfsFileInfo", true);
        record.data.put("hasResourceInfo", true);
        record.data.put("hash", "123");
    }

    @Test
    public void apkFileTest() {
        record.data.put("name", "android_super_app.apk");
        Assert.equals(false, fileNameFilter.process(record));
    }

    @Test
    public void regularFileTest() {
        record.data.put("name", "just_file.jpg");
        Assert.equals(true, fileNameFilter.process(record));
    }
}
