package ru.yandex.chemodan.app.stat.antiporno.processors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.app.stat.antiporno.collectors.DataCollector;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.mime.detect.MediaType;

/**
 * @author metal
 */
public class MediaTypeFilter extends AbstractFilter {
    private static final Logger logger = LoggerFactory.getLogger(MediaTypeFilter.class);

    private final ListF<MediaType> mediaTypes = Cf.list(
            MediaType.COMPRESSED, MediaType.VIDEO, MediaType.IMAGE, MediaType.UNKNOWN);

    public MediaTypeFilter(ListF<DataCollector> dataCollectors) {
        super(dataCollectors);
        ignorePrivateFiles = false;
    }

    @Override
    protected boolean filter(PornoCheckRecord record) {
        boolean result = !record.data.containsKeyTs("hasResourceInfo") || "dir".equals(record.data.getTs("type")) ||
                hasProperMediaType(record);
        if (!result) {
            logger.info("File have have been filtered by media type");
        }
        return result;
    }

    private boolean hasProperMediaType(PornoCheckRecord record) {
        try {
            return record.data.containsKeyTs("media_type") &&
                    mediaTypes.containsTs(MediaType.valueOf(record.<String>getTypedData("media_type").get().toUpperCase()));
        } catch (IllegalArgumentException e) {
            logger.info("File has unknown media type, skipping", e);
            return false;
        }
    }
}
