package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class MediaTypeFilterTest extends AbstractAntipornoTest {

    @Autowired
    private MediaTypeFilter mediaTypeFilter;

    private PornoCheckRecord record;

    @Before
    public void initRecord() {
        record = AntipornoTestData.createEmptyPublicFileRecord();
        record.data.put("hasMpfsFileInfo", true);
        record.data.put("hash", "123");
        record.data.put("name", "foobar");
        record.data.put("hasResourceInfo", true);
    }

    @Test
    public void dirFileTest() {
        record.data.put("type", "dir");
        Assert.equals(true, mediaTypeFilter.process(record));
    }

    @Test
    public void videoFileTest() {
        record.data.put("type", "file");
        record.data.put("media_type", "video");
        Assert.equals(true, mediaTypeFilter.process(record));
    }

    @Test
    public void documentFileTest() {
        record.data.put("type", "file");
        record.data.put("media_type", "document");
        Assert.equals(false, mediaTypeFilter.process(record));
    }

    @Test
    public void emptyMediaTypeFileTest() {
        record.data.put("type", "file");
        Assert.equals(false, mediaTypeFilter.process(record));
    }
}


