package ru.yandex.chemodan.app.stat.antiporno.processors;

import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.app.stat.antiporno.collectors.DataCollector;
import ru.yandex.chemodan.app.stat.antiporno.scores.Score;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class NameDetector extends AbstractDetector {
    private static final Logger logger = LoggerFactory.getLogger(NameDetector.class);

    private final DynamicProperty<ListF<String>> restrictedRegexps = new DynamicProperty<>(
            "antifo.antiporno.detectors.name.restricted.regexps",
            Cf.arrayList("boy", "girl", ".*[0-9]+yo", "footjob", "anal", ".*pussy.*",
            "preteen", ".*fuck.*", ".*blowjob.*", ".*-year-old.*", "kid", "!!!.*and dad", ".*bath", ".*lick.*",
            ".*and.*mom", "cum", "mom.*daughter", "Mom", "Dad", ".*little.*", "bj", "ass"));

    private final DynamicProperty<Double> nameDetectorScoreWeight =
            new DynamicProperty<>("antifo.antiporno.detectors.name.weight", 1.);

    public NameDetector(ListF<DataCollector> dataCollectors) {
        super(dataCollectors);
        ignorePrivateFiles = false;
    }

    @Override
    protected void detect(PornoCheckRecord record) {
        if (record.data.containsKeyTs("name")) {
            Option<Score> score = detect(record.<String>getTypedData("name").get());
            if (score.isPresent()) {
                logger.info("File have restricted name: {}", score.get().cause);
                record.scores.add(score.get());
            }
        } else {
            record.addToCheckedFilesCollection = false;
        }
    }

    private Option<Score> detect(String name) {
        String[] parts = name.split("\\W+|\\+|\\-|_");
        for (String part : parts) {
            for (String restrictedRegexp : restrictedRegexps.get()) {
                if (Pattern.compile(restrictedRegexp, Pattern.CASE_INSENSITIVE).matcher(part).find()) {
                    String cause = String.format("Name '%s' contains regexp: %s", name, restrictedRegexp);
                    return Option.of(new Score("name", 1.0, nameDetectorScoreWeight.get(), cause));
                }
            }
        }
        return Option.empty();
    }
}
