package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class NameDetectorTest extends AbstractAntipornoTest {

    @Autowired
    private NameDetector nameDetector;

    private PornoCheckRecord record;

    @Before
    public void initRecord() {
        record = AntipornoTestData.createEmptyPublicFileRecord();
        record.data.put("hasMpfsFileInfo", true);
    }

    @Test
    public void restrictedName() {
        record.data.put("name", "perfect preteen video 8yo.avi");
        Assert.equals(true, nameDetector.process(record));
        Assert.equals(1, record.scores.size());
        Assert.equals("name", record.scores.get(0).detector);
        Assert.assertContains(record.scores.get(0).cause, "contains regexp");
    }

    @Test
    public void properName() {
        record.data.put("name", "perfect video.avi");
        Assert.equals(true, nameDetector.process(record));
        Assert.equals(0, record.scores.size());
    }

    @Test
    public void emptyName() {
        Assert.equals(true, nameDetector.process(record));
        Assert.equals(0, record.scores.size());
    }
}
