package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.mulca.MulcaClientContextConfiguration;
import ru.yandex.chemodan.test.ClassLoaderTestUtils;
import ru.yandex.chemodan.test.MulcaTestManager;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
@ContextConfiguration(classes = MulcaClientContextConfiguration.class)
public class PreviewRecognitionDetectorTest extends AbstractAntipornoTest {
    @Autowired
    private MulcaClient mulcaClient;

    @Autowired
    private PreviewRecognitionDetector previewRecognitionDetector;

    private PornoCheckRecord record;

    @Before
    public void initRecord() {
        record = AntipornoTestData.createEmptyPublicFileRecord();
        record.data.put("hasMpfsFileInfo", true);
        record.data.put("hash", "123");
        record.data.put("hasResourceInfo", true);
    }

    @Test
    public void imageWithoutPorno() {
        InputStreamSource in = ClassLoaderTestUtils.byteStreamSourceForResource(
                PreviewRecognitionDetectorTest.class, "300.jpg");

        MulcaTestManager testManager = new MulcaTestManager(mulcaClient);
        testManager.withUploadedToMulcaFile(in, false,
                mulcaId -> {
                    record.data.put("preview", mulcaClient.getDownloadUri(mulcaId).toString());

                    Assert.equals(true, previewRecognitionDetector.process(record));
                    Assert.equals(0, record.scores.size());
                }
        );
    }
}
