package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.chemodan.app.stat.antiporno.collectors.DataCollector;
import ru.yandex.chemodan.app.stat.antiporno.scores.Score;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class TimeDetector extends AbstractDetector {
    private static final Logger logger = LoggerFactory.getLogger(TimeDetector.class);

    private final DynamicProperty<Double> nameDetectorScoreWeight =
            new DynamicProperty<>("antifo.antiporno.detectors.time.weight", 1.);

    private final DynamicProperty<Integer> maximumElapsedTimeForPublication =
            new DynamicProperty<>("antifo.antiporno.detectors.time.elapsed.max", 1800);

    public TimeDetector(ListF<DataCollector> dataCollectors) {
        super(dataCollectors);
    }

    @Override
    protected void detect(PornoCheckRecord record) {
        if (record.data.containsKeyTs("ptime") && record.data.containsKeyTs("reg_time")) {
            Duration publicationTime = Duration.standardSeconds(record.<Long>getTypedData("ptime").get());
            Duration registrationTime = Duration.standardSeconds(record.<Long>getTypedData("reg_time").get());
            Duration currentMaxElapsedTime = Duration.standardSeconds(maximumElapsedTimeForPublication.get());
            Duration elapsedTime = publicationTime.minus(registrationTime);
            if (elapsedTime.isShorterThan(currentMaxElapsedTime)) {
                logger.info("Elapsed time between user registration and file publication is {}s and it is less than {}s",
                        elapsedTime.getStandardSeconds(),
                        currentMaxElapsedTime.getStandardSeconds());

                String cause = String.format("elapsed time between user registration and file publication is less than %d minutes",
                        currentMaxElapsedTime.getStandardMinutes());
                record.scores.add(new Score("time", 1.0, nameDetectorScoreWeight.get(), cause));
            }
        } else {
            record.addToCheckedFilesCollection = false;
        }
    }
}
