package ru.yandex.chemodan.app.stat.antiporno.processors;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.stat.antiporno.AbstractAntipornoTest;
import ru.yandex.chemodan.app.stat.antiporno.AntipornoTestData;
import ru.yandex.chemodan.app.stat.antiporno.PornoCheckRecord;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class TimeDetectorTest extends AbstractAntipornoTest {

    @Autowired
    private TimeDetector timeDetector;

    private PornoCheckRecord record;

    @Before
    public void initRecord() {
        record = AntipornoTestData.createEmptyPublicFileRecord();
        record.data.put("hasMpfsFileInfo", true);
        record.data.put("hash", "123");
        record.data.put("hasPublicationTime", true);
    }

    @Test
    public void smallElapsedTimeBetweenUserRegistrationAndFilePublication() {
        record.data.put("ptime", 1395146474L);
        record.data.put("reg_time", 1395146400L);
        Assert.equals(true, timeDetector.process(record));
        Assert.equals(1, record.scores.size());
        Assert.equals("time", record.scores.get(0).detector);
        Assert.assertContains(record.scores.get(0).cause, "elapsed time between user registration and file publication is less than");
    }

    @Test
    public void properTime() {
        record.data.put("ptime", 1395146474L);
        record.data.put("reg_time", 1395140000L);
        Assert.equals(true, timeDetector.process(record));
        Assert.equals(0, record.scores.size());
    }
}

