package ru.yandex.chemodan.app.stat.antiporno.scores;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;

/**
 * @author metal
 */
@BenderBindAllFields
public class AutoAntiPornoScores {
    private static final BenderParserSerializer<AutoAntiPornoScores> antiPornoScoresSerializer = Bender.cons(
            AutoAntiPornoScores.class,
            BenderConfiguration.defaultConfiguration());

    public final double total;
    public final ListF<Score> scores;

    public AutoAntiPornoScores(ListF<Score> scores) {
        this.scores = scores;
        this.total = countTotalScore();
    }

    private double countTotalScore() {
        double res = 0;
        for (Score score : scores) {
            res += score.weight * score.value;
        }
        return res;
    }

    @Override
    public String toString() {
        return new String(antiPornoScoresSerializer.getSerializer().serializeJson(this));
    }
}
