package ru.yandex.chemodan.app.stat.limits;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@ActionResultPojo
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class LimitedInfo extends DefaultObject {
    public static final LimitedInfo EMPTY = new LimitedInfo(Cf.map(), Cf.map());

    public final MapF<String, Instant> authLimited;
    public final MapF<String, Instant> publicLimited;

    public final boolean authBlocked;
    public final boolean publicBlocked;

    public LimitedInfo(MapF<String, Instant> authLimited, MapF<String, Instant> publicLimited) {
        this(authLimited, publicLimited, false, false);
    }

    public LimitedInfo(MapF<String, Instant> authLimited, MapF<String, Instant> publicLimited,
                       boolean authBlocked, boolean publicBlocked) {
        this.authLimited = authLimited;
        this.publicLimited = publicLimited;
        this.authBlocked = authBlocked;
        this.publicBlocked = publicBlocked;
    }

    public ListF<String> getLimitTypes() {
        return authLimited.keys().map(Cf.String.addSuffixF(".auth"))
                .plus(publicLimited.keys().map(Cf.String.addSuffixF(".public")));
    }

    public ListF<String> getLimitAuths() {
        return Option.when(authLimited.isNotEmpty(), "auth").plus(Option.when(publicLimited.isNotEmpty(), "public"));
    }
}
