package ru.yandex.chemodan.app.stat.limits;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class ViewsAndTrafficLimitTest {

    @Test
    public void limited() {
        Assert.isFalse(new ViewsAndTrafficLimits(Option.empty(), Option.empty())
                .isLimited(DataSize.fromBytes(1000), 15));

        Assert.isFalse(new ViewsAndTrafficLimits(Option.empty(), Option.of(10L))
                .isLimited(DataSize.fromBytes(1000), 5));

        Assert.isFalse(new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(1001)), Option.of(16L))
                .isLimited(DataSize.fromBytes(1000), 15));

        Assert.isTrue(new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(1000)), Option.of(16L))
                .isLimited(DataSize.fromBytes(1000), 15));
        Assert.isTrue(new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(1000)), Option.empty())
                .isLimited(DataSize.fromBytes(1000), 15));

        Assert.isTrue(new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(1001)), Option.of(15L))
                .isLimited(DataSize.fromBytes(1000), 15));
        Assert.isTrue(new ViewsAndTrafficLimits(Option.empty(), Option.of(15L))
                .isLimited(DataSize.fromBytes(1000), 15));

        Assert.isTrue(new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(1000)), Option.of(15L))
                .isLimited(DataSize.fromBytes(1000), 15));
    }

}
