package ru.yandex.chemodan.app.stat.limits;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ViewsAndTrafficLimits extends DefaultObject {
    public static final ViewsAndTrafficLimits EMPTY =
            new ViewsAndTrafficLimits(Option.empty(), Option.empty());

    public final Option<DataSize> traffic;
    public final Option<Long> views;

    public ViewsAndTrafficLimits(Option<DataSize> traffic, Option<Long> views) {
        this.traffic = traffic;
        this.views = views;
    }

    public boolean isLimited(DataSize traffic, long views) {
        return this.traffic.isPresent() && this.traffic.get().le(traffic)
                || this.views.isPresent() && this.views.get() <= views;
    }

    public boolean isEmpty() {
        return !traffic.isPresent() && !views.isPresent();
    }
}
