package ru.yandex.chemodan.app.stat.limits.block;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@ActionResultPojo
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class BlockInfo extends DefaultObject {
    public static final BlockInfo EMPTY = new BlockInfo(Option.empty(), Option.empty());

    public final Option<Instant> publicBlocked;
    public final Option<Instant> authBlocked;

    public BlockInfo(Option<Instant> publicBlocked, Option<Instant> authBlocked) {
        this.publicBlocked = publicBlocked;
        this.authBlocked = authBlocked;
    }
}
