package ru.yandex.chemodan.app.stat.limits.block;

import com.mongodb.DB;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.chemodan.app.stat.TestUtils;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class BlockedDownloadsDaoTest {

    @BeforeClass
    public static void prepareLogger() {
        TestHelper.initialize();
    }

    @Test
    public void simple() {

        DB db = TestUtils.testMongoDb();
        BlockedDownloadsDao dao = new BlockedDownloadsDao(db.getCollection("blocked"));

        DownloadStatId id = new DownloadStatId("6ab7684b26c1cdcf4e556d5237530ec3");
        dao.unblockAll(id);

        dao.block(id, true);
        Assert.isTrue(dao.isBlocked(id, true));
        Assert.isFalse(dao.isBlocked(id, false));

        dao.block(id, false);
        Assert.isTrue(dao.isBlocked(id, true));
        Assert.isTrue(dao.isBlocked(id, false));

        dao.unblock(id, true);
        Assert.isFalse(dao.isBlocked(id, true));
        Assert.isTrue(dao.isBlocked(id, false));
    }
}
