package ru.yandex.chemodan.app.stat.limits.channel;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ChannelAndAuth extends DefaultObject {
    public final String channel;
    public final boolean auth;

    public ChannelAndAuth(String channel, boolean auth) {
        this.channel = channel;
        this.auth = auth;
    }

    public static Function<ChannelAndAuth, String> getChannelF() {
        return object -> object.channel;
    }

    public static Function1B<ChannelAndAuth> getAuthF() {
        return channelAndAuth -> channelAndAuth.auth;
    }
}
