package ru.yandex.chemodan.app.stat.limits.channel;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.stat.limits.ViewsAndTrafficLimits;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
@ActionResultPojo
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ChannelLimits extends DefaultObject {
    public static final BenderParserSerializer<ChannelLimits> PS = Bender.cons(ChannelLimits.class);

    public final String channelName;
    public final ViewsAndTrafficLimits authLimit;
    public final ViewsAndTrafficLimits publicLimit;

    public ChannelLimits(String channel, ViewsAndTrafficLimits authLimit, ViewsAndTrafficLimits publicLimit) {
        this.channelName = channel;
        this.authLimit = authLimit;
        this.publicLimit = publicLimit;
    }

    public boolean isEmpty() {
        return authLimit.isEmpty() && publicLimit.isEmpty();
    }

    public static Function<ChannelLimits, String> channelNameF() {
        return object -> object.channelName;
    }

    public ListF<ChannelAndAuth> getLimitedTypes(DataSize traffic, long views) {
        ListF<ChannelAndAuth> result = Cf.arrayList();
        if (authLimit.isLimited(traffic, views)) {
            result.add(new ChannelAndAuth(channelName, true));
        }
        if (publicLimit.isLimited(traffic, views)) {
            result.add(new ChannelAndAuth(channelName, false));
        }
        return result;
    }
}
