package ru.yandex.chemodan.app.stat.limits.channel;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.Zk;
import ru.yandex.commune.zk2.primitives.ZkPathClient;
import ru.yandex.commune.zk2.primitives.group.GroupWatcherListener;
import ru.yandex.commune.zk2.primitives.group.ZkGroupWatcher;
import ru.yandex.misc.bender.BenderBoltsUtils;

/**
 * @author Lev Tolmachev
 */
public class ChannelLimitsRegistry extends ZkPathClient implements GroupWatcherListener {
    private MapF<String, ChannelLimits> limits = Cf.map();

    private final ZkGroupWatcher groupWatcher;

    public ChannelLimitsRegistry(ZkPath zkPath) {
        super(zkPath);
        this.groupWatcher = new ZkGroupWatcher(zkPath, this);
    }

    public void removeLimit(ChannelLimits limits) {
        zk().deleteIfExists(path.child(limits.channelName));
    }

    public void setChannelLimit(ChannelLimits limits) {
        ZkPath child = path.child(limits.channelName);
        zk().deleteIfExists(child);
        zk().createOrUpdate(child, ChannelLimits.PS.getSerializer().serializeJson(limits));
    }

    public MapF<String, ChannelLimits> getLimits() {
        return limits;
    }

    @Override
    public void groupChanged(ListF<byte[]> members) {
        limits = members
                .map(BenderBoltsUtils.parseJsonBytesF(ChannelLimits.PS.getParser()))
                .toMapMappingToKey(ChannelLimits.channelNameF());
    }

    @Override
    public void initialize(Zk zk) {
        super.initialize(zk);
        groupWatcher.initialize(zk);
    }

    @Override
    public void expired() {
        super.expired();
        groupWatcher.expired();
    }
}
