package ru.yandex.chemodan.app.stat.limits.channel;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.limits.ViewsAndTrafficLimits;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class ChannelLimitsTest {
    @Test
    public void limited() {
        ChannelLimits limits = new ChannelLimits("channel",
                new ViewsAndTrafficLimits(Option.of(DataSize.fromBytes(100)), Option.empty()),
                new ViewsAndTrafficLimits(Option.empty(), Option.of(10L)));

        Assert.equals(
                Cf.list(new ChannelAndAuth("channel", true)),
                limits.getLimitedTypes(DataSize.fromBytes(1000), 0)
        );

        Assert.equals(
                Cf.list(new ChannelAndAuth("channel", false)),
                limits.getLimitedTypes(DataSize.fromBytes(10), 11)
        );

        Assert.equals(
                Cf.list(new ChannelAndAuth("channel", true), new ChannelAndAuth("channel", false)),
                limits.getLimitedTypes(DataSize.fromBytes(1000), 11)
        );
    }
}
