package ru.yandex.chemodan.app.stat.limits.mediatype;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimits;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Lev Tolmachev
 */
@Bendable
@ActionResultPojo
public class MediatypeLimits {

    public static final BenderParserSerializer<MediatypeLimits> PS = Bender.cons(MediatypeLimits.class);

    @BenderPart
    public final String mediatype;
    @BenderPart
    public final ListF<ChannelLimits> channelLimits;

    private MapF<String, ChannelLimits> limitsByChannel;

    public MediatypeLimits(String mediatype, ListF<ChannelLimits> channelLimits) {
        this.mediatype = mediatype;
        this.channelLimits = channelLimits;
        this.limitsByChannel = channelLimits.toMapMappingToKey(ChannelLimits.channelNameF());
    }

    public MediatypeLimits withChangedChannelLimits(ChannelLimits limits) {
        if (!limits.isEmpty()) {
            return new MediatypeLimits(mediatype, limitsByChannel.plus1(limits.channelName, limits).values().toList());
        } else {
            return new MediatypeLimits(mediatype, channelLimits
                    .filter(ChannelLimits.channelNameF().andThenEquals(limits.channelName).notF()));
        }
    }

    public MapF<String, ChannelLimits> getLimitsByChannel() {
        if (limitsByChannel == null) {
            limitsByChannel = channelLimits.toMapMappingToKey(ChannelLimits.channelNameF());
        }
        return limitsByChannel;
    }

    public Option<ChannelLimits> getLimits(String channel) {
        return getLimitsByChannel().getO(channel);
    }

    public boolean isEmpty() {
        return channelLimits.isEmpty();
    }

    public static Function<MediatypeLimits, String> getMediatypeF() {
        return object -> object.mediatype;
    }

    public static Function0<MediatypeLimits> consF(final String mediatype) {
        return () -> new MediatypeLimits(mediatype, Cf.list());
    }
}
