package ru.yandex.chemodan.app.stat.limits.mediatype;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.ZkPathClient;
import ru.yandex.commune.zk2.primitives.group.GroupWatcherListener;
import ru.yandex.misc.bender.BenderBoltsUtils;

/**
 * @author Lev Tolmachev
 */
public class MediatypeLimitsRegistry extends ZkPathClient implements GroupWatcherListener {
    private MapF<String, MediatypeLimits> limits = Cf.map();

    public void removeMediatypeLimits(String mediatype) {
        zk().deleteIfExists(path.child(mediatype));
    }

    public void setMediatypeLimits(MediatypeLimits limits) {
        ZkPath child = path.child(limits.mediatype);
        zk().deleteIfExists(child);
        zk().createOrUpdate(child, MediatypeLimits.PS.getSerializer().serializeJson(limits));
    }

    public Option<MediatypeLimits> getLimits(String mediatype) {
        return limits.getO(mediatype);
    }

    public MediatypeLimitsRegistry(ZkPath zkPath) {
        super(zkPath);
    }

    @Override
    public void groupChanged(ListF<byte[]> members) {
        limits = members.map(BenderBoltsUtils.parseJsonBytesF(MediatypeLimits.PS.getParser()))
                .toMapMappingToKey(MediatypeLimits.getMediatypeF());
    }

    public ListF<MediatypeLimits> getLimits() {
        return limits.values().toList();
    }
}
