package ru.yandex.chemodan.app.stat.limits.whitelist;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.app.stat.storage.util.DownloadStatIdMarshaller;
import ru.yandex.chemodan.app.stat.storage.util.DownloadStatIdUnmarshaller;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class WhitelistEntry extends DefaultObject {
    public static final BenderParserSerializer<WhitelistEntry> PS = Bender.cons(WhitelistEntry.class,
            new BenderConfiguration(
                    BenderConfiguration.defaultSettings(),
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(DownloadStatId.class, new DownloadStatIdUnmarshaller())
                            .add(DownloadStatId.class, new DownloadStatIdMarshaller())
                            .build()
            ));

    @BenderPart(name = "hid")
    public final DownloadStatId id; // name saved for backward compatibility
    public final String description;

    public WhitelistEntry(DownloadStatId id, String description) {
        this.id = id;
        this.description = description;
    }

    public DownloadStatId getId() {
        return id;
    }

    public static Function<WhitelistEntry, DownloadStatId> getIdF() {
        return WhitelistEntry::getId;
    }
}
